#version 330
#extension GL_EXT_gpu_shader4 : enable
//subiendo a cielo de nocheMod01.fsh by jorge2017a1

//https://www.shadertoy.com/view/3t3czs
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//por jorge2017a1- 03/ene/2021
#define MAX_STEPS 100
#define MAX_DIST 100.
#define MIN_DIST 0.001
#define EPSILON 0.001
//---prevoid common---//
///------------------------------------
struct TObj
{
    float id_color;
    float id_objeto;
    float id_material;
    float dist;
    vec3 normal;
    vec3 ro;
    vec3 rd;
    vec2 uv;
    vec3 color;
    vec3 p;
    vec3 rf;
    float marchCount;
    bool blnShadow; 
};

    
TObj mObj;
vec3 glpRoRd;
vec2 gres2;
float itime;

#define PI 3.14159265358979323846264
#define PI2 6.28318530717
#define TriplePI (3.0 * PI)
#define DoublePI (2.0 * PI)
#define HalfPI (PI / 2.0)
#define MATERIAL_NO -1.0
#define COLOR_NO -1.0



vec3  Arrcolores[] = vec3[] (
vec3(0,0,0)/255.0,  //0
vec3(255.,255.,255.)/255.0, //1
vec3(255,0,0)/255.0,  //2
vec3(0,255,0)/255.0,   //3
vec3(0,0,255)/255.0,   //4
vec3(255,255,0)/255.0,  //5
vec3(0,255,255)/255.0,  //6 
vec3(255,0,255)/255.0,   //7
vec3(192,192,192)/255.0,  //8
vec3(128,128,128)/255.0,  //9
vec3(128,0,0)/255.0,   //10
vec3(128,128,0)/255.0,  //11
vec3(0,128,0)/255.0,   //12
vec3(128,0,128)/255.0,  //13
vec3(0,128,128)/255.0,  //14
vec3(0,0,128)/255.0,    //15
vec3(255, 204, 188)/255.0,  //16
vec3(0.8, 0.8, 0.8),  //17
vec3(0.5, 0.5, 0.8),  //18
vec3(1, 0.5, 0),      //19
vec3(1.0, 1.0, 1.0),  //20
vec3(247./255., 168./255.,  184./255.),  //21
vec3(0, 1, 1),                           //22 
vec3(85./255., 205./255., 252./255.),    //23
vec3(0.425, 0.56, 0.9)*vec3( 0.3, 0.2, 1.0 ),  //24 
vec3(0.8,0.8,0.8)*vec3( 0.3, 0.2, 1.0 ),       //25  
vec3(1.0,0.01,0.01)*vec3( 0.3, 0.2, 1.0 ),     //26
vec3(0.1, 0.5, 1.0),                           //27   
vec3(0.0, 0.6, 0.0),                       //28 
vec3(0.1,0.1,0.7),                          //29
vec3(0.99, 0.2, 0.1) //30
);

//----------------------------------------------------
vec3 getColor(int i)
{    
    if (i==-2 ) {return mObj.color; }       
    if (i>-1 ) 
		return Arrcolores[i];
}
///--------------------------------------------


//---end prevoid common---//

vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);
vec3 getMaterial( vec3 pp, float id_material);


vec3 light_pos1   ;
vec3 light_color1 ;
vec3 light_pos2   ;
vec3 light_color2 ;
//operacion de Union
#define opU3(d1, d2) ( d1.x < d2.x ? d1 : d2 )
#define opU2(d1, d2) ( d1.x < d2.x ? d1 : d2 )

float sdSphere( vec3 p, float s )
	{ return length(p)-s;}
float sdBox( vec3 p, vec3 b )
	{ vec3 d = abs(p) - b;   return length(max(d,0.0))+ min(max(d.x,max(d.y,d.z)),0.0); }
float sdCylinderYZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.yz),p.x)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xz),p.y)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXY( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xy),p.z)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }

///----------Operacion de Distancia--------
float intersectSDF(float distA, float distB)
	{ return max(distA, distB);}

float unionSDF(float distA, float distB)
	{ return min(distA, distB);}

float differenceSDF(float distA, float distB)
	{ return max(distA, -distB);}
//-------------------------------------------
// object transformation
vec3 rotate_x(vec3 p, float phi)
{
    float c = cos(phi);	float s = sin(phi);
    return vec3(p.x, c*p.y - s*p.z, s*p.y + c*p.z);
}
vec3 rotate_y(vec3 p, float phi)
{
	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x + s*p.z, p.y, c*p.z - s*p.x);
}
vec3 rotate_z(vec3 p, float phi)
{
	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x - s*p.y, s*p.x + c*p.y, p.z);
}
///------------------------------------
float tau = atan(1.0) * 8.0;

mat2 genRotMat(float val){
	return mat2(cos(val),-sin(val),sin(val),cos(val));
}

vec3 opAngRep( vec3 p, float a )
{
	vec2 polar = vec2(atan(p.y, p.x), length(p.xy));
    polar.x = mod(polar.x + a / 2.0, a) - a / 2.0;
    
    return vec3(polar.y * vec2(cos(polar.x),sin(polar.x)), p.z);
}


vec2 cilindrobase(vec3 p )
{
    float tau = atan(1.0) * 8.0;
    p= rotate_x(p , radians(90.0));
    float numItem=8.0;
    float ang=tau / numItem;
    vec3 p2= opAngRep(p, ang );
    float sb0= sdCylinderXY(p-vec3(0.0,0.0,0.0), vec2(10.0,0.5) );  //base
    float sb1= sdCylinderXY(p2-vec3(10.0,0.0,2.0), vec2(0.5,3.0) ); //postes rep
    float sb3A= sdCylinderXY(p-vec3(0.0,0.0,4.0), vec2(10.0,0.5) ); //anillo a
    float sb3B= sdCylinderXY(p-vec3(0.0,0.0,4.0), vec2(9.0,0.6) );  //anillo a
    float sb3C= sdCylinderXY(p-vec3(0.0,0.0,4.0), vec2(6.0,12.0) ); //centro
    sb3A= differenceSDF(sb3A, sb3B);
    vec2 resp=vec2(9999.9,-1.0);
    resp=opU2(resp, vec2(sb0, 1.0) );
    resp=opU2(resp, vec2(sb1, 2.0) );
    resp=opU2(resp, vec2(sb3A, 12.0) );
    resp=opU2(resp, vec2(sb3C, 11.0) );
    return resp;
}

///------------------------------------
vec3 GetDist(vec3 p  ) 
{	
	vec3 res;
    vec3 pp=p;
    res = vec3(9999.0, -1.0,-1.0);
    //p= rotate_y(p-vec3(0.0,0.0,0.0), clamp(0.0, radians(15.0), 0.5*sin(iTime*0.5)) );
    p= rotate_y(p-vec3(0.0,0.0,0.0), clamp(sin(iTime*0.5),0.0, (20.0) ) );
	
	vec3 q=p;
    float cx=47.0;
    float cy=12.0;
    float cz=50.00;
    q.y = mod(q.y+0.5*cy,cy)-0.5*cy;
    q.z = mod(q.z+0.5*cz,cz)-0.5*cz;
    q.x = mod(q.x+0.5*cx,cx)-0.5*cx;
    p=q;
	
    
  
     vec2 cb1= cilindrobase(p);
     res =opU3(res, vec3(cb1.x,cb1.y,MATERIAL_NO)); 
    
    //res =opU3(res, vec3(1.0,0.0,MATERIAL_NO)); 
    //return (dist, id_color, id_material)
    return res;
}



vec3 LightShadingV2(vec3 normal,vec3 p, vec3 ro,vec3 rd, vec3 plight_pos,vec3 color)
{   
    vec3 final = vec3( 0.0 );
    //const float shininess = 64.0;
    float shininess = 64.;
    vec3 lig = normalize(plight_pos);
	vec3 l = normalize( p-plight_pos);
    vec3 v = normalize( p-ro);
    vec3 h = normalize(v + l);
    
    vec3 r = reflect(-l, normal);
    vec3 ref = reflect(lig, normal);
    
    vec3 vl = normalize( plight_pos - p );
    vec3 ref_v = reflect( v, normal );
    float diffuse  = max( 0.0, dot( vl, normal ) );
    float specular = max( 0.0, dot( vl, ref_v ) );
	float fre = pow(clamp(1.0 + dot(normal, rd), 0.0, 1.0), 2.0);
    float dom = smoothstep(-1.0, 1.0, r.y);
    	specular = pow( specular, shininess );
		final += color * ( diffuse + specular);
   return  final;
    
}   


//------------------------------------------------
vec3 GetNormal(vec3 p)
{
	float d = GetDist(p).x;
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(
        GetDist(p-e.xyy).x,
        GetDist(p-e.yxy).x,
        GetDist(p-e.yyx).x);
    return normalize(n);
}
//---------actualizacion por Shane---28-may-2020    ...gracias
float RayMarch(vec3 ro, vec3 rd){
    float dO = 0.; 
    vec3 dS=vec3(9999.0,-1.0,-1.0);
    float marchCount = 0.0;
    vec3 p;
    for(int i=0; i<MAX_STEPS; i++) 
    {
    	p = ro + rd*dO;
        dS = GetDist(p);
        
        if(dO>MAX_DIST || abs(dS.x)<MIN_DIST) break;
        dO += dS.x;
        marchCount++;
         
    }
    
    mObj.dist = dO;
    mObj.id_color = dS.y;
    mObj.marchCount=marchCount;
    mObj.id_material=dS.z;
    mObj.normal=GetNormal(p);
    return dO;
}

//---------------------------------------------------
float GetShadow(vec3 p, vec3 plig)
{
    vec3 lightPos = plig;
    vec3 l = normalize(lightPos-p);
    vec3 n = GetNormal(p);
    float dif = clamp(dot(n, l), 0., 1.);
    float d = RayMarch(p+n*MIN_DIST*2., l );
    if(d<length(lightPos-p)) dif *= .1;
    return dif;
}
//----------------------------------------------------
//-------------------------------------------
//-------------------------------
vec3 Getluz(vec3 p, vec3 ro, vec3 rd, vec3 nor , vec3 colobj ,vec3 plight_pos)
{
    float intensity=1.0;
     vec3 result;
	 result = LightShadingV2(nor,p, ro, rd, plight_pos, colobj)*intensity;
    
    if (mObj.blnShadow==true)
    {
    	float fhadow=GetShadow(p,plight_pos);
    	return result*fhadow;
        
     }
    else
    {  return result; }
}
///-------------------------------------
//-------------------------------------------------

vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material)
{
   	vec3 colobj; 
    if (id_color<100)
		{ colobj=getColor(int( id_color)); }
    return colobj;
}




///---------------------------------------------
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
   vec2 uv = (gl_FragCoord.xy -.5*iResolution.xy)/iResolution.y;
   mObj.uv=uv;
    float t;
    t=mod(iTime*5.0,1000.0);
    itime=t;
	//mObj.blnShadow=false;
    mObj.blnShadow=true;
        
 	light_pos1= vec3(10.0, 6.0, 10.0 );  light_color1 = vec3( 1.0 );
 	light_pos2= vec3( -5.0, 6.0, -5.0 ); light_color2 = vec3( 1.0, 1.0, 1.0 );
 
    vec3 ro=vec3(0.0,7.0+t,-25.0+5.0*sin(t*0.25));
    //ro= getMouse(ro);       
    vec3 rd=normalize(vec3(uv,1.0));
    
    
    light_pos1+=ro;
    light_pos2+=ro;
    
    
    vec3 col = vec3(0);
    TObj Obj;
    mObj.rd=rd;
    mObj.ro=ro;
    
    float d = RayMarch(ro, rd);
    Obj=mObj;
    vec3 p = (ro + rd * d ); 
    
    mObj.p=p;
    mObj.dist =d;
    vec3 nor=mObj.normal;

    vec3 colobj;
    colobj=GetColorYMaterial( p, nor, ro, rd,  int( Obj.id_color), Obj.id_material);
    
    
	float dif1=1.0;
   	vec3 result;
    result=  Getluz( p,ro,rd, nor, colobj ,light_pos1);
    result+= Getluz( p,ro,rd, nor, colobj ,light_pos2);
    result/=1.25;
    col= result*dif1;
    
     

  	//sugerencia por dean_the_coder,
    //col *= 1.0 - pow(d / 100.0, 1.5);
    col *= 1.0 - pow(d /(MAX_DIST) , 3.5);    
    col = pow(col, vec3(1.0/2.2));  
    gl_FragColor = vec4(col,1.0);
}
